// Persistence of Vision Ray Tracer Scene Description File
// File: SimpleNetAnimator.pov
// Vers: intentionally unspecified
// Desc: A super simple system for networked computers to "distribute" frames to render.  
// Actually each machine either renders a legitimate frame from local SDL and creates a 
// centrally-located and approprietely numbered "flag-file", or renders a blank frame if 
// this "flag-file" already exists.  The blank frames should be quick, small if 
// compressed, and easy to sort out. External scripts, programs or any sort of a 
// frame-server are all avoided in this way - it's pure POV.
// 
// Set up a shared network directory to place flag-files and make sure POV-Ray on all
// machines can read & write to this directory.  You'll need to define
// NetworkPathForFrameFlags, FrameFlagName, AnimationSceneFile and optionally
// ThisComputersName and MakeFrameFlagSummary:
//
// NetworkPathForFrameFlags - String ending with a backslash and specifying the shared 
//                            directory where flag-files can be placed.  Don't forget
//                            to double the backslashes.
// FrameFlagName            - String specifying the basic, un-numbered name for the 
//                            flag-files. It doesn't have to match AnimationSceneFile.
// AnimationSceneFile       - Specifies the file to be animated! 
// 
// ThisComputersName        - "<Unspecified>" by default, this optional identifier
//                            can be set on each machine to identify the creator of 
//                            each frame-flag. This information can also be #included
//                            from a file unique to each machine.
// MakeFrameFlagSummary     - If this is defined and "true" the contents of all the
//                            frame flags will be listed, line by line in frame order
//                            in a new file created after the last frame (or subset).
// Date: 2007-01-25  Last updated: 2007-06-07
// Auth: Charles C



//   * * * * * * * * * * * * * * *  EDIT THIS SECTION TO SUIT * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
//
// ***************************************************************************************************************************
// ***** The all-important settings of what and where ************************************************************************
//                      
// It would be nice to pass these strings in from the .ini file but since we can only
// do that with float constants, it'll need to be done in SDL.  Modify this file,
// #include this file from another, but in either case we need E.g.:
//
// Generic Sample:
// #local NetworkPathForFrameFlags = "\\\\NetDrive\\SharedDir\\POV\\Animation\\FrameFlags\\";
// #local FrameFlagName            = "F_Flag_MyAnimation";
// #local AnimationSceneFile       = "MyAnimation.pov";
// #local ThisComputerName         = "<Unspecified>";
// #local MakeFrameFlagSummary     = yes;
//
// Edit this:
#local NetworkPathForFrameFlags = "\\\\NAS1\\SharedDir\\P_Scenes_Replacable_Distro\\Frame_Flags\\";
#local FrameFlagName            = "F_Flag_psychedelic scrambler_";
#local AnimationSceneFile       = "psychedelic scrambler.pov";
//#local ThisComputersName         = "<Unspecified>"; //Can be set in "ThisComputersName.txt"
#local MakeFrameFlagSummary   = yes; //dumps contents of flag-files into one file upon rendering last frame.
//
// ***************************************************************************************************************************



//   * * * * * * * * * * * * * * *  COPY & PASTE FROM THIS SECTION TO SUIT * * * * * * * * * * * * * * * * * * * * * * * * * * 
//
// ***************************************************************************************************************************
// ***** Optional features like safe stopping and stats **********************************************************************
//
// The following file should NOT be distributed to other computers. I put this file in 
// each machine's "\bucket_of_renders\" directory as I call it, which I also have on 
// the Library_Path.  I put it there instead of with the other SDL files because I 
// copy an updated SDL directory tree to each machine just before rendering... 
//
// File name: "ThisComputersName.txt"
// Contents of this file can contain any or all of the following:
//
////// File name: "ThisComputersName.txt"
////#declare ThisComputersName = "Computer_1";
//////
////#declare ThisComputer_Active_Or_Not = yes; //Must be yes to render legitimate frames.
//////
////// Modify to stop specific instances:         0   1   2   3   4   5   6   7   8   9  10
////#declare Instance_Activity_Array = array[11]{yes,yes,yes,yes,yes,yes,yes,yes,yes,yes,yes}
////                                             
//
//; The following can be added to the command line. I find it convienient to put both lines
//; commented out in the .ini file and paste them into each instance's command line:
//; +oc:\bucket_of_renders\new_animation_dir_1\  Declare=Instance_Number=1
//; +oc:\bucket_of_renders\new_animation_dir_2\  Declare=Instance_Number=2
//
// Declare=Instance_Number=2 on the command line might be useful if using 
// MakeFrameFlagSummary and multiple instances of POV-Ray on the same machine.
//
// ***************************************************************************************************************************



// ***************************************************************************************************************************
// ***** This little block is the real bit... ********************************************************************************
//
// Computer ID & Intance ID:
#if(file_exists("ThisComputersName.txt")) #include "ThisComputersName.txt" #end
#ifdef(Instance_Number) 
    #declare ThisComputersName = concat(ThisComputersName, str(Instance_Number,0,0) ); 
#else
    #declare Instance_Number = 0; //default
#end
//
// Safe stopping of some or all instances on this computer:
#ifndef(ThisComputer_Active_Or_Not) #local ThisComputer_Active_Or_Not = yes;         #end
#ifdef ( Instance_Activity_Array)      //These lines allow some instances of POV-Ray to be
  #if( ThisComputer_Active_Or_Not )    //stoped safely while others keep going
    #declare ThisComputer_Active_Or_Not = Instance_Activity_Array[Instance_Number];
  #end //end if
#end //end ifdef
//
// Ensuring mandatory settings are defined:
#ifndef(NetworkPathForFrameFlags) #error "Please define NetworkPathForFrameFlags.\n" #end
#ifndef(FrameFlagName)            #error "Please define FrameFlagName.\n"            #end
#ifndef(AnimationSceneFile)       #error "Please define AnimationSceneFile.\n"       #end
#ifndef(ThisComputersName)  
  #declare ThisComputersName = "<Unspecified>"; //default
  #warning "You can define a unique ThisComputerName for each machine. \"<Unspecified>\" is being used instead.\n" 
#end
//
#local ThisFramesFlagFile = concat(NetworkPathForFrameFlags, FrameFlagName, str(frame_number,0,0),".txt") ;
//
#if(file_exists(ThisFramesFlagFile))    
   //then render a blank scene.... but not without a few invisible spheres to make sure bounding doesn't turn off!:  
   #local SphereCtr = 0;
   #while (SphereCtr < 25) //Try to use the minimum to meet Bounding threshold.  10 seems to be the magic # but the docs say 25.
      sphere{<0,0,0>, .0001  translate x*1 rotate y*(360/25)*SphereCtr no_image no_shadow no_reflection  } //to avoid no bounding bug
      #local SphereCtr = SphereCtr + 1;
   #end  //end while
   //
   #local RenderingThisFrame = no; //only needed for optional section below
#else
   //put a flag file in the shared directory:
   #if(ThisComputer_Active_Or_Not=yes)
     #fopen NewFlagFile ThisFramesFlagFile write
     #write(NewFlagFile, concat("\"Frame number ", str(frame_number,0,0), " has been flagged by ", ThisComputersName, ".\"\n"))
     #fclose NewFlagFile
     //and render a legitimate frame:
     #include AnimationSceneFile
     #local RenderingThisFrame = yes; //only needed for optional section below
   #else
     #local RenderingThisFrame = no; //only needed for optional section below
     #debug "It's safe to stop rendering. There's no risk of creating incomplete yet flagged frames. Rendering blank frames.\n"
   #end //end #if(ThisComputer_Active_Or_Not=yes)
#end
//
// ***************************************************************************************************************************



// ***************************************************************************************************************************
// ***** The following implementation of options is entirely... optional and can be deleted or commented out. ****************
//
#ifndef(MakeFrameFlagSummary) #local MakeFrameFlagSummary = no; #end
#if( ((frame_number = final_frame) & RenderingThisFrame) & MakeFrameFlagSummary )
   //then this machine is rendering the final frame and gets the honor of putting 
   //the contents of the flag-files into a single file in the shared directory:
   #local FrameFlagsListFileName = concat(NetworkPathForFrameFlags, FrameFlagName, "_Summary.txt");
   #fopen  NewFrameFlagSummary FrameFlagsListFileName write
   #fclose NewFrameFlagSummary //contents are now erased
   #fopen  NewFrameFlagSummary FrameFlagsListFileName append //and open again ready for line items.
   #write( NewFrameFlagSummary, concat("AnimationSceneFile was : \"", AnimationSceneFile,  "\"\n") )
   #write( NewFrameFlagSummary, concat("initial_clock was      : ", str(initial_clock,0,8),  "\n") )
   #write( NewFrameFlagSummary, concat("final_clock   was      : ", str(final_clock,0,8),  "\n") )
   #write( NewFrameFlagSummary, concat("initial_frame was      : ", str(initial_frame,0,0),  "\n") )
   #write( NewFrameFlagSummary, concat("final_frame   was      : ", str(final_frame,0,0),  "\n\n\n") )
   //
   #local FrameFlagFile_Ctr = initial_frame;
   #while (FrameFlagFile_Ctr <= final_frame)
      #local A_FlagFileName = concat(NetworkPathForFrameFlags, FrameFlagName, str(FrameFlagFile_Ctr,0,0),".txt") ;
      #if(file_exists(A_FlagFileName) )
         #fopen A_FlagFile A_FlagFileName read
         #read ( A_FlagFile, A_FlagFile_String) 
         #fclose A_FlagFile      
      #else
         #local A_FlagFile_String = concat("\n    FrameFlag number ", str(FrameFlagFile_Ctr,0,0), " is missing!\n");
      #end //end if
      #write( NewFrameFlagSummary, concat(A_FlagFile_String,"\n") )
      #local FrameFlagFile_Ctr = FrameFlagFile_Ctr +1;
   #end //end while
   //
   #fclose NewFrameFlagSummary
#end //end if
//
// ***************************************************************************************************************************




